{*
 * Projecte Fressa a LINKAT
 * GLOBUS3
 *
 * @author Jordi Lagares Roset "jlagares@xtec.cat - www.lagares.org"
 * amb el suport del Departament d'Educacio de la Generalitat de Catalunya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details (see the LICENSE file).
 *}

unit UnitGrisos;

{************************************************}
INTERFACE
{************************************************}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, ExtCtrls, MMSystem, StdCtrls;

type
  TFormGrisos = class(TForm)
    Panel: TPanel;
    SpeedButtonEngegarParar: TSpeedButton;
    SpeedButtonCopiarALaCarpeta: TSpeedButton;
    RadioButtonBlanc: TRadioButton;
    RadioButtonVerd: TRadioButton;
    RadioButtonBlau: TRadioButton;
    RadioButtonVermell: TRadioButton;
    RadioButtonGroc: TRadioButton;
    procedure SpeedButtonEngegarPararClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SpeedButtonCopiarALaCarpetaClick(Sender: TObject);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
    procedure WMWIMDATA(var Msg: TMessage); message MM_WIM_DATA;
  public
    { Public declarations }
  end;

var
  FormGrisos: TFormGrisos;

{************************************************}
IMPLEMENTATION
{************************************************}

uses UnitEntradaSo, RainBow, UnitCanviDeparametres, UnitTools;

{$R *.DFM}

procedure TFormGrisos.FormClose(Sender: TObject;var Action: TCloseAction);
begin
  if not (SpeedButtonEngegarParar.Caption='E') then begin
    PararEntradaSo;
    FinalitzarEntradaSo;
    SpeedButtonEngegarParar.Caption:='E';
    SpeedButtonEngegarParar.Down:=false;
  end;
end;

procedure TFormGrisos.SpeedButtonEngegarPararClick(Sender: TObject);
begin
  if SpeedButtonEngegarParar.Caption='E' then begin
    SpeedButtonEngegarParar.Caption:='P';
    RePaint;
    IniciarDadesUnitEntradaSo(512);
    EngegarProcesEntradaSo(Handle);
  end else begin
    PararEntradaSo;
    FinalitzarEntradaSo;
    SpeedButtonEngegarParar.Caption:='E';
  end;
end;

procedure TFormGrisos.WMWIMDATA(var Msg: TMessage);
var
  i,Max:integer;
  //R:TRect;
  //PaintDC:HDC;
begin
  Max:=0;
  For i:=1 to BytesBuffer do if so[NumeroBufer,i]-127>Max then Max:=so[NumeroBufer,i]-127;
  //Color:=RGB(255-2*Max,255-2*Max,255-2*Max);
  if Max>0 then begin
    if RadioButtonBlanc.Checked then begin
      Color:=RGB(2*Max-1,2*Max-1,2*Max-1);
    end else if RadioButtonVerd.Checked then begin
      Color:=RGB(0,2*Max-1,0);
    end else if RadioButtonBlau.Checked then begin
      Color:=RGB(0,0,2*Max-1);
    end else if RadioButtonVermell.Checked then begin
      Color:=RGB(2*Max-1,0,0);
    end else if RadioButtonGroc.Checked then begin
      Color:=RGB(2*Max-1,2*Max-1,0);
    end;
  end else Color:=RGB(0,0,0);
  EntradaSo;
end;

procedure TFormGrisos.SpeedButtonCopiarALaCarpetaClick(Sender: TObject);
var
  Rect:TRect;
begin
  Rect.Left:=0;
  Rect.Top:=Panel.Height;
  Rect.Right:=ClientRect.Right;
  Rect.Bottom:=ClientRect.Bottom;
  CopiarPartDeLaFinestraALaCarpeta(Handle,Rect);
end;

procedure TFormGrisos.FormMouseDown(Sender: TObject; Button: TMouseButton;Shift: TShiftState; X, Y: Integer);
begin
  if Button=mbleft then begin
  end else begin
    if not (SpeedButtonEngegarParar.Caption='E') then begin
      PararEntradaSo;
      FinalitzarEntradaSo;
      SpeedButtonEngegarParar.Caption:='E';
      SpeedButtonEngegarParar.Down:=false;
    end;
  end;
end;

end.
